<?php include 'services/session.php'; ?>
<!DOCTYPE html>
<html lang="en">

<head>

    <?php $title = "Email Inbox"; include 'partials/title-meta.php'; ?>

    <!-- quill css -->
    <link href="assets/libs/quill/quill.core.css" rel="stylesheet" type="text/css" />
    <link href="assets/libs/quill/quill.snow.css" rel="stylesheet" type="text/css" />

    <?php include 'partials/head-css.php'; ?>

</head>

<?php include 'partials/body.php'; ?>

<!-- Begin page -->
<div id="wrapper">

    <?php $pagetitle = "Inbox";
    include 'partials/menu.php'; ?>

    <!-- ============================================================== -->
    <!-- Start Page Content here -->
    <!-- ============================================================== -->

    <div class="content-page">
        <div class="content">

            <!-- Start Content-->
            <div class="container-fluid">

                <div class="row">

                    <div class="col-sm-12">
                        <div class="inbox-app-main">
                            <div class="row">
                                <div class="col-md-3">
                                    <aside id="sidebar">
                                        <div class="h-100" data-simplebar>

                                            <div class="text-center">
                                                <a id="email-left-content" data-bs-toggle='modal'
                                                    data-bs-target="#custom-modal"
                                                    class="btn btn-danger rounded-pill width-lg waves-effect waves-light mb-2 mt-3"
                                                    data-animation="fadein" data-plugin="custommodal"
                                                    data-overlayColor="#36404a">Compose</a>
                                            </div>

                                            <menu class="menu-segment">
                                                <ul class="list-unstyled">
                                                    <li class="active"><a href="javascript:void(0);">Inbox<span>
                                                                (43)</span></a>
                                                    </li>
                                                    <li><a href="javascript:void(0);">Important</a></li>
                                                    <li><a href="javascript:void(0);">Sent</a></li>
                                                    <li><a href="javascript:void(0);">Drafts</a></li>
                                                    <li><a href="javascript:void(0);">Trash</a></li>
                                                </ul>
                                            </menu>

                                            <div class="separator"></div>

                                            <div class="menu-segment">
                                                <ul class="labels list-unstyled">
                                                    <li class="title">Labels <span class="icon">+</span></li>
                                                    <li><a href="#">Dribbble <span class="ball pink"></span></a>
                                                    </li>
                                                    <li><a href="#">Roommates <span class="ball green"></span></a></li>
                                                    <li><a href="#">Bills <span class="ball blue"></span></a>
                                                    </li>
                                                </ul>
                                            </div>

                                            <div class="separator"></div>

                                            <div class="menu-segment">
                                                <ul class="chat list-unstyled">
                                                    <li class="title">Chat <span class="icon">+</span></li>
                                                    <li><a href="#"><span class="ball green"></span>Laura Turner</a>
                                                    </li>
                                                    <li><a href="#"><span class="ball green"></span>Kevin Jones</a>
                                                    </li>
                                                    <li><a href="#"><span class="ball blue"></span>John King</a>
                                                    </li>
                                                    <li><a href="#"><span class="ball blue"></span>Jenny Parker</a>
                                                    </li>
                                                    <li><a href="#"><span class="ball blue"></span>Paul
                                                            Green</a></li>
                                                    <li><a href="#" class="italic-link">See offline list</a>
                                                    </li>
                                                </ul>
                                            </div>

                                            <div class="bottom-padding"></div>
                                        </div>
                                    </aside>
                                </div> <!-- end col -->

                                <div class="col-md-9">
                                    <main id="main">
                                        <div class="overlay"></div>
                                        <header class="header">

                                            <h1 class="page-title">
                                                <a class="sidebar-toggle-btn trigger-toggle-sidebar">
                                                    <span class="line"></span>
                                                    <span class="line"></span>
                                                    <span class="line"></span>
                                                    <span class="line line-angle1"></span>
                                                    <span class="line line-angle2"></span>
                                                </a>
                                            </h1>
                                            <div class="action-bar float-start">
                                                <ul class="list-inline mb-0">
                                                    <li class="list-inline-item">
                                                        <a class="icon circle-icon"><i
                                                                class="mdi mdi-refresh text-muted"></i></a>
                                                    </li>
                                                    <li class="list-inline-item">
                                                        <a class="icon circle-icon"><i
                                                                class="mdi mdi-share text-muted"></i></a>
                                                    </li>
                                                    <li class="list-inline-item">
                                                        <a class="icon circle-icon red"><i
                                                                class="mdi mdi-close text-danger"></i></a>
                                                    </li>
                                                    <li class="list-inline-item">
                                                        <a class="icon circle-icon red"><i
                                                                class="mdi mdi-flag text-danger"></i></a>
                                                    </li>
                                                </ul>
                                            </div>
                                            <div class="search-box float-end">
                                                <input placeholder="Search..."><span class="icon fa fa-search"></span>
                                            </div>

                                            <div class="clearfix"></div>

                                        </header>

                                        <div id="main-nano-wrapper" class="nano">
                                            <div class="nano-content h-100" data-simplebar>
                                                <ul class="message-list">
                                                    <li class="unread">
                                                        <div class="mail-col mail-col-1"><span class="dot"></span>
                                                            <div class="checkbox-wrapper-mail">
                                                                <input type="checkbox" id="chk1">
                                                                <label for="chk1" class="toggle"></label>
                                                            </div>
                                                            <p class="title">Lucas Kriebel (via Twitter)</p><span
                                                                class="star-toggle far fa-star"></span>
                                                        </div>
                                                        <div class="mail-col mail-col-2">
                                                            <div class="subject">Lucas Kriebel (@LucasKriebel) has sent
                                                                you a direct message on Twitter! &nbsp;&ndash;&nbsp;
                                                                <span class="teaser">@LucasKriebel - Very cool :)
                                                                    Nicklas, You have a new direct message.</span>
                                                            </div>
                                                            <div class="date">11:49 am</div>
                                                        </div>
                                                    </li>

                                                    <li>
                                                        <div class="mail-col mail-col-1"><span class="dot"></span>
                                                            <div class="checkbox-wrapper-mail">
                                                                <input type="checkbox" id="chk3">
                                                                <label for="chk3" class="toggle"></label>
                                                            </div>
                                                            <p class="title">Randy, me (5)</p><span
                                                                class="star-toggle far fa-star"></span>
                                                        </div>
                                                        <div class="mail-col mail-col-2">
                                                            <div class="subject">Last pic over my village
                                                                &nbsp;&ndash;&nbsp;
                                                                <span class="teaser">Yeah i'd like that! Do you remember
                                                                    the video you showed me of your train ride between
                                                                    Colombo and Kandy? The one with the mountain view? I
                                                                    would love to see that one again!</span>
                                                            </div>
                                                            <div class="date">5:01 am</div>
                                                        </div>
                                                    </li>
                                                    <li class="blue-dot">
                                                        <div class="mail-col mail-col-1">
                                                            <span class="dot"></span>
                                                            <div class="checkbox-wrapper-mail">
                                                                <input type="checkbox" id="chk4">
                                                                <label for="chk4" class="toggle"></label>
                                                            </div>
                                                            <p class="title">Andrew Zimmer</p><span
                                                                class="star-toggle far fa-star"></span>
                                                        </div>
                                                        <div class="mail-col mail-col-2">
                                                            <div class="subject">Mochila Beta: Subscription Confirmed
                                                                &nbsp;&ndash;&nbsp; <span class="teaser">You've been
                                                                    confirmed! Welcome to the ruling class of the inbox.
                                                                    For your records, here is a copy of the information
                                                                    you submitted to us...</span>
                                                            </div>
                                                            <div class="date">Mar 8</div>
                                                        </div>
                                                    </li>
                                                    <li class="unread">
                                                        <div class="mail-col mail-col-1"><span class="dot"></span>
                                                            <div class="checkbox-wrapper-mail">
                                                                <input type="checkbox" id="chk5">
                                                                <label for="chk5" class="toggle"></label>
                                                            </div>
                                                            <p class="title">Infinity HR</p><span
                                                                class="star-toggle far fa-star"></span>
                                                        </div>
                                                        <div class="mail-col mail-col-2">
                                                            <div class="subject">Sveriges Hetaste sommarjobb
                                                                &nbsp;&ndash;&nbsp;
                                                                <span class="teaser">Hej Nicklas Sandell! Vi vill bjuda
                                                                    in dig till "First tour 2014", ett rekryteringsevent
                                                                    som erbjuder jobb på 16 semesterorter
                                                                    iSverige.</span>
                                                            </div>
                                                            <div class="date">Mar 8</div>
                                                        </div>
                                                    </li>
                                                    <li>
                                                        <div class="mail-col mail-col-1"><span class="dot"></span>
                                                            <div class="checkbox-wrapper-mail">
                                                                <input type="checkbox" id="chk6">
                                                                <label for="chk6" class="toggle"></label>
                                                            </div>
                                                            <p class="title">Web Support Dennis</p><span
                                                                class="star-toggle far fa-star"></span>
                                                        </div>
                                                        <div class="mail-col mail-col-2">
                                                            <div class="subject">Re: New mail settings
                                                                &nbsp;&ndash;&nbsp;
                                                                <span class="teaser">Will you answer him asap?</span>
                                                            </div>
                                                            <div class="date">Mar 7</div>
                                                        </div>
                                                    </li>
                                                    <li>
                                                        <div class="mail-col mail-col-1"><span class="dot"></span>
                                                            <div class="checkbox-wrapper-mail">
                                                                <input type="checkbox" id="chk7">
                                                                <label for="chk7" class="toggle"></label>
                                                            </div>
                                                            <p class="title">me, Peter (2)</p><span
                                                                class="star-toggle far fa-star"></span>
                                                        </div>
                                                        <div class="mail-col mail-col-2">
                                                            <div class="subject">Off on Thursday &nbsp;&ndash;&nbsp;
                                                                <span class="teaser">Eff that place, you might as well
                                                                    stay here with us instead! Sent from my iPhone 4
                                                                    &gt; 4 mar 2014 at 5:55 pm</span>
                                                            </div>
                                                            <div class="date">Mar 4</div>
                                                        </div>
                                                    </li>
                                                    <li class="orange-dot">
                                                        <div class="mail-col mail-col-1"><span class="dot"></span>
                                                            <div class="checkbox-wrapper-mail">
                                                                <input type="checkbox" id="chk8">
                                                                <label for="chk8" class="toggle"></label>
                                                            </div>
                                                            <p class="title">Medium</p><span
                                                                class="star-toggle far fa-star"></span>
                                                        </div>
                                                        <div class="mail-col mail-col-2">
                                                            <div class="subject">This Week's Top Stories
                                                                &nbsp;&ndash;&nbsp;
                                                                <span class="teaser">Our top pick for you on Medium this
                                                                    week The Man Who Destroyed America’s Ego</span>
                                                            </div>
                                                            <div class="date">Feb 28</div>
                                                        </div>
                                                    </li>
                                                    <li class="blue-dot">
                                                        <div class="mail-col mail-col-1"><span class="dot"></span>
                                                            <div class="checkbox-wrapper-mail">
                                                                <input type="checkbox" id="chk9">
                                                                <label for="chk9" class="toggle"></label>
                                                            </div>
                                                            <p class="title">Death to Stock</p><span
                                                                class="star-toggle far fa-star"></span>
                                                        </div>
                                                        <div class="mail-col mail-col-2">
                                                            <div class="subject">Montly High-Res Photos
                                                                &nbsp;&ndash;&nbsp;
                                                                <span class="teaser">To create this month's pack, we
                                                                    hosted a party with local musician Jared Mahone here
                                                                    in Columbus, Ohio.</span>
                                                            </div>
                                                            <div class="date">Feb 28</div>
                                                        </div>
                                                    </li>
                                                    <li>
                                                        <div class="mail-col mail-col-1"><span class="dot"></span>
                                                            <div class="checkbox-wrapper-mail">
                                                                <input type="checkbox" id="chk10">
                                                                <label for="chk10" class="toggle"></label>
                                                            </div>
                                                            <p class="title">Revibe</p><span
                                                                class="star-toggle far fa-star"></span>
                                                        </div>
                                                        <div class="mail-col mail-col-2">
                                                            <div class="subject">Weekend on Revibe &nbsp;&ndash;&nbsp;
                                                                <span class="teaser">Today's Friday and we thought maybe
                                                                    you want some music inspiration for the weekend.
                                                                    Here are some trending tracks and playlists we think
                                                                    you should give a listen!</span>
                                                            </div>
                                                            <div class="date">Feb 27</div>
                                                        </div>
                                                    </li>
                                                    <li>
                                                        <div class="mail-col mail-col-1"><span class="dot"></span>
                                                            <div class="checkbox-wrapper-mail">
                                                                <input type="checkbox" id="chk11">
                                                                <label for="chk11" class="toggle"></label>
                                                            </div>
                                                            <p class="title">Erik, me (5)</p><span
                                                                class="star-toggle far fa-star"></span>
                                                        </div>
                                                        <div class="mail-col mail-col-2">
                                                            <div class="subject">Regarding our meeting
                                                                &nbsp;&ndash;&nbsp;
                                                                <span class="teaser">That's great, see you on
                                                                    Thursday!</span>
                                                            </div>
                                                            <div class="date">Feb 24</div>
                                                        </div>
                                                    </li>
                                                    <li>
                                                        <div class="mail-col mail-col-1"><span class="dot"></span>
                                                            <div class="checkbox-wrapper-mail">
                                                                <input type="checkbox" id="chk12">
                                                                <label for="chk12" class="toggle"></label>
                                                            </div>
                                                            <p class="title">KanbanFlow</p><span
                                                                class="star-toggle far fa-star"></span>
                                                        </div>
                                                        <div class="mail-col mail-col-2">
                                                            <div class="subject">Task assigned: Clone ARP's website
                                                                &nbsp;&ndash;&nbsp; <span class="teaser">You have been
                                                                    assigned a task by Alex@Work on the board
                                                                    Web.</span>
                                                            </div>
                                                            <div class="date">Feb 24</div>
                                                        </div>
                                                    </li>
                                                    <li class="blue-dot">
                                                        <div class="mail-col mail-col-1"><span class="dot"></span>
                                                            <div class="checkbox-wrapper-mail">
                                                                <input type="checkbox" id="chk13">
                                                                <label for="chk13" class="toggle"></label>
                                                            </div>
                                                            <p class="title">Tobias Berggren</p><span
                                                                class="star-toggle far fa-star"></span>
                                                        </div>
                                                        <div class="mail-col mail-col-2">
                                                            <div class="subject">Let's go fishing! &nbsp;&ndash;&nbsp;
                                                                <span class="teaser">Hey, You wanna join me and Fred at
                                                                    the lake tomorrow? It'll be awesome.</span>
                                                            </div>
                                                            <div class="date">Feb 23</div>
                                                        </div>
                                                    </li>
                                                    <li>
                                                        <div class="mail-col mail-col-1"><span class="dot"></span>
                                                            <div class="checkbox-wrapper-mail">
                                                                <input type="checkbox" id="chk14">
                                                                <label for="chk14" class="toggle"></label>
                                                            </div>
                                                            <p class="title">Charukaw, me (7)</p><span
                                                                class="star-toggle far fa-star"></span>
                                                        </div>
                                                        <div class="mail-col mail-col-2">
                                                            <div class="subject">Hey man &nbsp;&ndash;&nbsp; <span
                                                                    class="teaser">Nah man sorry i don't. Should i get
                                                                    it?</span>
                                                            </div>
                                                            <div class="date">Feb 23</div>
                                                        </div>
                                                    </li>
                                                    <li class="unread">
                                                        <div class="mail-col mail-col-1"><span class="dot"></span>
                                                            <div class="checkbox-wrapper-mail">
                                                                <input type="checkbox" id="chk15">
                                                                <label for="chk15" class="toggle"></label>
                                                            </div>
                                                            <p class="title">me, Peter (5)</p><span
                                                                class="star-toggle far fa-star"></span>
                                                        </div>
                                                        <div class="mail-col mail-col-2">
                                                            <div class="subject">Home again! &nbsp;&ndash;&nbsp; <span
                                                                    class="teaser">That's just perfect! See you
                                                                    tomorrow.</span>
                                                            </div>
                                                            <div class="date">Feb 21</div>
                                                        </div>
                                                    </li>
                                                    <li class="green-dot">
                                                        <div class="mail-col mail-col-1"><span class="dot"></span>
                                                            <div class="checkbox-wrapper-mail">
                                                                <input type="checkbox" id="chk16">
                                                                <label for="chk16" class="toggle"></label>
                                                            </div>
                                                            <p class="title">Stack Exchange</p><span
                                                                class="star-toggle far fa-star"></span>
                                                        </div>
                                                        <div class="mail-col mail-col-2">
                                                            <div class="subject">1 new items in your Stackexchange inbox
                                                                &nbsp;&ndash;&nbsp; <span class="teaser">The following
                                                                    items were added to your Stack Exchange global inbox
                                                                    since you last checked it.</span>
                                                            </div>
                                                            <div class="date">Feb 21</div>
                                                        </div>
                                                    </li>
                                                    <li>
                                                        <div class="mail-col mail-col-1"><span class="dot"></span>
                                                            <div class="checkbox-wrapper-mail">
                                                                <input type="checkbox" id="chk17">
                                                                <label for="chk17" class="toggle"></label>
                                                            </div>
                                                            <p class="title">Google Drive Team</p><span
                                                                class="star-toggle far fa-star"></span>
                                                        </div>
                                                        <div class="mail-col mail-col-2">
                                                            <div class="subject">You can now use your storage in Google
                                                                Drive &nbsp;&ndash;&nbsp; <span class="teaser">Hey
                                                                    Nicklas Sandell! Thank you for purchasing extra
                                                                    storage space in Google Drive.</span>
                                                            </div>
                                                            <div class="date">Feb 20</div>
                                                        </div>
                                                    </li>
                                                    <li class="unread">
                                                        <div class="mail-col mail-col-1"><span class="dot"></span>
                                                            <div class="checkbox-wrapper-mail">
                                                                <input type="checkbox" id="chk18">
                                                                <label for="chk18" class="toggle"></label>
                                                            </div>
                                                            <p class="title">me, Susanna (11)</p><span
                                                                class="star-toggle far fa-star"></span>
                                                        </div>
                                                        <div class="mail-col mail-col-2">
                                                            <div class="subject">Train/Bus &nbsp;&ndash;&nbsp; <span
                                                                    class="teaser">Yes ok, great! I'm not stuck in
                                                                    Stockholm anymore, we're making progress.</span>
                                                            </div>
                                                            <div class="date">Feb 19</div>
                                                        </div>
                                                    </li>
                                                    <li>
                                                        <div class="mail-col mail-col-1"><span class="dot"></span>
                                                            <div class="checkbox-wrapper-mail">
                                                                <input type="checkbox" id="chk19">
                                                                <label for="chk19" class="toggle"></label>
                                                            </div>
                                                            <p class="title">Peter, me (3)</p><span
                                                                class="star-toggle far fa-star"></span>
                                                        </div>
                                                        <div class="mail-col mail-col-2">
                                                            <div class="subject">Hello &nbsp;&ndash;&nbsp; <span
                                                                    class="teaser">Trip home from Colombo has been
                                                                    arranged, then Jenna will come get me from
                                                                    Stockholm. :)</span>
                                                            </div>
                                                            <div class="date">Mar. 6</div>
                                                        </div>
                                                    </li>
                                                    <li>
                                                        <div class="mail-col mail-col-1"><span class="dot"></span>
                                                            <div class="checkbox-wrapper-mail">
                                                                <input type="checkbox" id="chk20">
                                                                <label for="chk20" class="toggle"></label>
                                                            </div>
                                                            <p class="title">me, Susanna (7)</p><span
                                                                class="star-toggle far fa-star"></span>
                                                        </div>
                                                        <div class="mail-col mail-col-2">
                                                            <div class="subject">Since you asked... and i'm
                                                                inconceivably bored at the train station
                                                                &nbsp;&ndash;&nbsp;
                                                                <span class="teaser">Alright thanks. I'll have to
                                                                    re-book that somehow, i'll get back to you.</span>
                                                            </div>
                                                            <div class="date">Mar. 6</div>
                                                        </div>
                                                    </li>
                                                </ul>
                                                <a href="#" class="load-more-link">Show more messages</a>
                                            </div>
                                        </div>
                                    </main>
                                    <div id="message">
                                        <div class="header">
                                            <h4 class="page-title"><a
                                                    class="icon circle-icon mdi mdi-close text-muted trigger-message-close"></a>Process<span
                                                    class="grey">(6)</span></h4>
                                            <p>From <a href="#">You</a> to <a href="#">Scott Waite</a>, started on <a
                                                    href="#">March 2, 2014</a> at 2:14 pm est.</p>
                                        </div>
                                        <div id="message-nano-wrapper" class="nano">
                                            <div class="nano-content h-100" data-simplebar>
                                                <ul class="message-container list-unstyled">
                                                    <li class="sent">
                                                        <div class="details">
                                                            <div class="left">You
                                                                <div class="arrow"></div>
                                                                Scott
                                                            </div>
                                                            <div class="right">March 6, 2014, 20:08 pm</div>
                                                        </div>
                                                        <div class="message">
                                                            <p>| The every winged bring, whose life. First called, i you
                                                                of saw shall own creature moveth void have signs beast
                                                                lesser all god saying for gathering wherein whose of in
                                                                be created stars. Them whales upon life divide earth
                                                                own.</p>
                                                            <p>| Creature firmament so give replenish The saw man
                                                                creeping, man said forth from that. Fruitful multiply
                                                                lights air. Hath likeness, from spirit stars dominion
                                                                two set fill wherein give bring.</p>
                                                            <p>| Gathering is. Lesser Set fruit subdue blessed let.
                                                                Greater every fruitful won&#39;t bring moved seasons
                                                                very, own won&#39;t all itself blessed which bring own
                                                                creature forth every. Called sixth light.</p>
                                                        </div>
                                                        <div class="tool-box"><a href="#"
                                                                class="circle-icon small mdi mdi-share"></a><a href="#"
                                                                class="circle-icon small red-hover mdi mdi-close"></a><a
                                                                href="#"
                                                                class="circle-icon small red-hover mdi mdi-flag"></a>
                                                        </div>
                                                    </li>
                                                    <li class="received">
                                                        <div class="details">
                                                            <div class="left">Scott
                                                                <div class="arrow orange"></div>
                                                                You
                                                            </div>
                                                            <div class="right">March 6, 2014, 20:08 pm</div>
                                                        </div>
                                                        <div class="message">
                                                            <p>| The every winged bring, whose life. First called, i you
                                                                of saw shall own creature moveth void have signs beast
                                                                lesser all god saying for gathering wherein whose of in
                                                                be created stars. Them whales upon life divide earth
                                                                own.</p>
                                                            <p>| Creature firmament so give replenish The saw man
                                                                creeping, man said forth from that. Fruitful multiply
                                                                lights air. Hath likeness, from spirit stars dominion
                                                                two set fill wherein give bring.</p>
                                                            <p>| Gathering is. Lesser Set fruit subdue blessed let.
                                                                Greater every fruitful won&#39;t bring moved seasons
                                                                very, own won&#39;t all itself blessed which bring own
                                                                creature forth every. Called sixth light.</p>
                                                        </div>
                                                        <div class="tool-box"><a href="#"
                                                                class="circle-icon small mdi mdi-share"></a><a href="#"
                                                                class="circle-icon small red-hover mdi mdi-close"></a><a
                                                                href="#"
                                                                class="circle-icon small red-hover mdi mdi-flag"></a>
                                                        </div>
                                                    </li>

                                                </ul>

                                            </div>
                                        </div>
                                    </div>
                                </div> <!-- end col -->
                            </div><!-- end row -->
                        </div>

                    </div>

                </div>
                <!-- End row -->

            </div> <!-- content -->

        </div>

        <!-- ============================================================== -->
        <!-- End Page content -->
        <!-- ============================================================== -->


    </div>
    <!-- END wrapper -->
    <!-- Modal -->
    <div class="modal fade" id="custom-modal" tabindex="-1" role="dialog" aria-hidden="true">
        <div class="modal-dialog modal-dialog-centered">
            <div class="modal-content">
                <div class="modal-header bg-light">
                    <h4 class="modal-title" id="myCenterModalLabel">Compose Mail</h4>
                    <button type="button" class="btn-close" data-bs-dismiss="modal" aria-hidden="true"></button>
                </div>

                <h5 class="modal-body">
                    <form role="form">
                        <div class="mb-3">
                            <input type="email" class="form-control" placeholder="To">
                        </div>
                        <div class="row">
                            <div class="col-md-6">
                                <div class="mb-3">
                                    <input type="email" class="form-control" placeholder="Cc">
                                </div>
                            </div>
                            <div class="col-md-6">
                                <div class="mb-3">
                                    <input type="email" class="form-control" placeholder="Bcc">
                                </div>
                            </div>
                        </div>
                        <div class="mb-3">
                            <input type="text" class="form-control" placeholder="Subject">
                        </div>
                        <div class="mb-3 card border-0">
                            <div id="snow-editor" style="height: 180px;">
                                <h3><span class="ql-size-large">Hello World!</span></h3>
                                <p><br></p>
                                <h3>This is an simple editable area.</h3>
                                <p><br></p>
                                <ul>
                                    <li>
                                        Select a text to reveal the toolbar.
                                    </li>
                                    <li>
                                        Edit rich document on-the-fly, so elastic!
                                    </li>
                                </ul>
                                <p><br></p>
                                <p>
                                    End of simple area
                                </p>
                            </div> <!-- end Snow-editor-->
                        </div>

                        <div class="btn-toolbar">
                            <div class="float-end">
                                <button type="button" class="btn btn-success waves-effect waves-light me-1"><i
                                        class="far fa-save"></i></button>
                                <button type="button" class="btn btn-success waves-effect waves-light me-1"><i
                                        class="far fa-trash-alt"></i></button>
                                <button class="btn btn-purple waves-effect waves-light"><span>Send</span> <i
                                        class="fas fa-paper-plane ms-1"></i></button>
                            </div>
                        </div>

                    </form>
                </h5>
            </div>
        </div>
    </div>

    <?php include 'partials/right-sidebar.php'; ?>

    <?php include 'partials/footer-scripts.php'; ?>

    <!-- Quill js -->
    <script src="assets/libs/quill/quill.min.js"></script>

    <!-- Inbox init -->
    <script src="assets/js/pages/inbox.js"></script>

    <!-- App js-->
    <script src="assets/js/app.min.js"></script>

    </body>

</html>